import re

# Crawled URL'lerin olduğu dosyayı oku
with open('crawled_urls.txt', 'r') as file:
    urls = file.readlines()

# Filtreleme için regex desenleri
php_id_pattern = re.compile(r'\.php\?id=', re.IGNORECASE)
register_pattern = re.compile(r'register', re.IGNORECASE)
admin_pattern = re.compile(r'/admin/', re.IGNORECASE)  # YENİ: /admin/ klasörünü aramak için desen eklendi

# Filtrelenmiş URL'leri saklamak için listeler
php_id_urls = []
register_urls = []
admin_urls = []  # YENİ: /admin/ URL'lerini saklamak için liste eklendi

# URL'leri tara
for url in urls:
    url = url.strip()  # Satır sonundaki boşlukları ve newline karakterini temizle
    
    # Her URL için ilgili desene uyup uymadığını kontrol et
    if php_id_pattern.search(url):
        php_id_urls.append(url)
    
    if register_pattern.search(url):
        register_urls.append(url)
        
    if admin_pattern.search(url):  # YENİ: /admin/ deseni için kontrol eklendi
        admin_urls.append(url)

# Sonuçları dosyalara yaz
with open('php_id_urls.txt', 'w') as f:
    for url in php_id_urls:
        f.write(url + '\n')

with open('register_urls.txt', 'w') as f:
    for url in register_urls:
        f.write(url + '\n')

# YENİ: /admin/ URL'lerini dosyaya yazmak için yeni bir blok eklendi
with open('admin_urls.txt', 'w') as f:
    for url in admin_urls:
        f.write(url + '\n')

# Bulunan URL sayılarını ekrana yazdır
print(f"'.php?id=' içeren {len(php_id_urls)} adet URL bulundu.")
print(f"'register' içeren {len(register_urls)} adet URL bulundu.")
print(f"'/admin/' içeren {len(admin_urls)} adet URL bulundu.") # YENİ: /admin/ sonucu için bilgilendirme mesajı eklendi